﻿<?LassoScript
/*
This demo shows how to mix different font styles within one PDF_Text object.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -margins = array( 25.0, 25.0, 25.0, 25.0), -nocompress));

// Setting font variables
var('Papyrus24' = (pdf_font:
	-file = 'fonts/Papyrus.ttf',
	-embed,
	-size = 24));

var('TimesPlain18' = (pdf_font:
	-face = 'Times-Roman',
	-size = 18));

var('TimesBold18' = (pdf_font:
	-face = 'Times-Bold',
	-size = 18));

var('TimesItalic18' = (pdf_font:
	-face = 'Times-Italic',
	-size = 18));

// Setting color variables
var('brownCMYK' = pdf_color('cmyk', 0, 0.75, 1, 0.40));
var('blueCMYK' = pdf_color('cmyk', 1, 0.5, 0, 0));
var('grayCMYK' = pdf_color('cmyk', 0.61, 0.52, 0.52, 0.22));


// Setting an empty PDF_Text object to use as a holder of the coming content
var('pdftext' = pdf_text( '',
		-type = 'paragraph',
		-leading = 20));

// Adding content to the existing PDF_Text var starting with a header
var('pdftext' = pdf_text( 'Famous quotes:',
		-type = 'paragraph',
		-font = $Papyrus24,
		-leading = 28,
	-color = $brownCMYK));

// since the earlier addition was of type paragraph we need to neutralize
// the PDF_Text object before we add more content
$pdftext -> add(pdf_text( '',
		-type = 'paragraph',
		-leading = 20));

// Adding first part of the quote
$pdftext -> add(pdf_text( 'Roll on, ',
	-type = 'chunk',
	-font = $TimesPlain18,
	-color = $grayCMYK));

// Second part of quote with different font and color values
$pdftext -> add(pdf_text( 'deep and dark blue ocean',
	-type = 'chunk',
	-font = $TimesBold18,
	-color = $blueCMYK));

// More text with different style
$pdftext -> add(pdf_text( ', roll. Ten thousand fleets sweep over thee in vain. ',
	-type = 'chunk',
	-font = $TimesPlain18,
	-color = $grayCMYK));

// Last part of the quote
$pdftext -> add(pdf_text( '\rMan marks the earth with ruin, but his control stops with the shore.',
	-type = 'chunk',
	-font = $TimesItalic18,
	-color = $grayCMYK));

// Wrapping it up with the author on a new row enabled by using type paragraph
$pdftext -> add(pdf_text( 'Lord Byron',
	-type = 'paragraph',
	-font = $TimesBold18,
	-color = $brownCMYK,
	-leading = 30));

// Time to add the concatenated PDF_Text object to the PDF_Doc
$pdf -> add($pdftext);

// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo8.pdf');

?>